import urllib2
import sys

########################################
# Define a function to send an HTTP command and get the result
########################################

def Get_HTTP_Result(CmdToSend):

    # Specify the IP address
    CmdToSend = "http://192.168.9.61/:" + CmdToSend

    # Send the HTTP command and try to read the result
    try:
        HTTP_Result = urllib2.urlopen(CmdToSend)
        PTE_Return = HTTP_Result.read()

    # Catch an exception if URL is incorrect (incorrect IP or disconnected)
    except:
        print "Error, no response from device; check IP address and connections."
        PTE_Return = "No Response!"
        sys.exit()      # Exit the script

    # Return the response
    return PTE_Return

########################################
# Send commands to the ZTM box:
#   Window 1 = SP4T
#   Window 2A & 2B = Attenuator
#   Window 3A & 3B = SPDT
########################################

# Print the model name and serial number
sn = Get_HTTP_Result("SN?")
mn = Get_HTTP_Result("MN?")
print mn, "/", sn

# Set SP4T switch
Get_HTTP_Result('SP4T:1:STATE:4')
SP4T_State = Get_HTTP_Result('SP4T:1:STATE?')
print "SP4T 1 =", SP4T_State

# Set attenuators
Get_HTTP_Result('RUDAT:2A:ATT:20.75')
Get_HTTP_Result('RUDAT:2B:ATT:30')
ATTA_State = Get_HTTP_Result('RUDAT:2A:ATT?')
ATTB_State = Get_HTTP_Result('RUDAT:2B:ATT?')
print "ATT 2A =", ATTA_State, "/ ATT 2B =", ATTB_State

# Set SPDT switches
Get_HTTP_Result('SPDT:3A:STATE:2')
Get_HTTP_Result('SPDT:3B:STATE:1')
SPDTA_State = Get_HTTP_Result('SPDT:3A:STATE?')
SPDTB_State = Get_HTTP_Result('SPDT:3B:STATE?')
print "SPDT 3A =", SPDTA_State, "/ SPDT 3B =", SPDTB_State

